/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.bettermineshafts.world.generator.pieces;

import com.yungnickyoung.minecraft.bettermineshafts.BetterMineshafts;
import com.yungnickyoung.minecraft.bettermineshafts.config.Configuration;
import com.yungnickyoung.minecraft.bettermineshafts.util.BoxUtil;
import com.yungnickyoung.minecraft.bettermineshafts.world.generator.MineshaftVariantSettings;
import com.yungnickyoung.minecraft.bettermineshafts.world.generator.pieces.MineshaftPiece;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.template.TemplateManager;

public class OreDeposit
extends MineshaftPiece {
    private OreType oreType;
    private static final int SECONDARY_AXIS_LEN = 5;
    private static final int Y_AXIS_LEN = 5;
    private static final int MAIN_AXIS_LEN = 4;
    private static final int LOCAL_X_END = 4;
    private static final int LOCAL_Y_END = 4;
    private static final int LOCAL_Z_END = 3;

    public OreDeposit() {
    }

    public OreDeposit(int i, int chunkPieceLen, Random random, StructureBoundingBox blockBox, EnumFacing direction, MineshaftVariantSettings settings) {
        super(i, chunkPieceLen, settings);
        this.func_186164_a(direction);
        this.field_74887_e = blockBox;
    }

    @Override
    @ParametersAreNonnullByDefault
    protected void func_143012_a(NBTTagCompound tag) {
        super.func_143012_a(tag);
        tag.func_74768_a("OreType", this.oreType.value);
    }

    @Override
    @ParametersAreNonnullByDefault
    protected void func_143011_b(NBTTagCompound tag, TemplateManager templateManager) {
        super.func_143011_b(tag, templateManager);
        this.oreType = OreType.valueOf(tag.func_74762_e("OreType"));
    }

    public static StructureBoundingBox determineBoxPosition(List<StructureComponent> list, Random random, int x, int y, int z, EnumFacing direction) {
        StructureBoundingBox blockBox = BoxUtil.boxFromCoordsWithRotation(x, y, z, 5, 5, 4, direction);
        StructureComponent intersectingPiece = StructureComponent.func_74883_a(list, (StructureBoundingBox)blockBox);
        return intersectingPiece != null ? null : blockBox;
    }

    @Override
    public void func_74861_a(StructureComponent structurePiece, List<StructureComponent> list, Random random) {
        int r = random.nextInt(100);
        for (OreType oreType : OreType.values()) {
            if (r >= oreType.threshold) continue;
            this.oreType = oreType;
            break;
        }
        if (OreType.DIAMOND.threshold != 100) {
            BetterMineshafts.LOGGER.error("Your ore spawn chances don't add up to 100! Ores won't spawn as you intend!");
        }
        if (this.oreType == null) {
            this.oreType = OreType.COBBLE;
        }
    }

    @ParametersAreNonnullByDefault
    public boolean func_74875_a(World world, Random random, StructureBoundingBox box) {
        if (this.func_74860_a(world, box)) {
            return false;
        }
        if (this.isInOcean(world, 0, 0) || this.isInOcean(world, 4, 3)) {
            return false;
        }
        IBlockState COBBLE = Blocks.field_150347_e.func_176223_P();
        IBlockState ORE_BLOCK = this.oreType.getBlock();
        this.chanceReplaceNonAir(world, box, random, 0.9f, 0, 0, 0, 4, 4, 3, COBBLE);
        this.chanceReplaceNonAir(world, box, random, 0.65f, 1, 1, 1, 3, 3, 2, ORE_BLOCK);
        this.chanceReplaceNonAir(world, box, random, 0.15f, 0, 0, 0, 4, 4, 3, ORE_BLOCK);
        return true;
    }

    public static enum OreType {
        COBBLE(0, Blocks.field_150347_e.func_176223_P(), Configuration.ores.cobble),
        COAL(1, Blocks.field_150365_q.func_176223_P(), Configuration.ores.coal + OreType.COBBLE.threshold),
        IRON(2, Blocks.field_150366_p.func_176223_P(), Configuration.ores.iron + OreType.COAL.threshold),
        REDSTONE(3, Blocks.field_150450_ax.func_176223_P(), Configuration.ores.redstone + OreType.IRON.threshold),
        GOLD(4, Blocks.field_150352_o.func_176223_P(), Configuration.ores.gold + OreType.REDSTONE.threshold),
        LAPIS(5, Blocks.field_150369_x.func_176223_P(), Configuration.ores.lapis + OreType.GOLD.threshold),
        EMERALD(6, Blocks.field_150412_bA.func_176223_P(), Configuration.ores.emerald + OreType.LAPIS.threshold),
        DIAMOND(7, Blocks.field_150482_ag.func_176223_P(), Configuration.ores.diamond + OreType.EMERALD.threshold);

        private final int value;
        private final IBlockState block;
        private int threshold;

        private OreType(int value, IBlockState block, int threshold) {
            this.value = value;
            this.block = block;
            this.threshold = threshold;
        }

        public static OreType valueOf(int value) {
            return Arrays.stream(OreType.values()).filter(oreType -> oreType.value == value).findFirst().get();
        }

        public IBlockState getBlock() {
            return this.block;
        }
    }
}

